# Scatter Plots for Site Count and Catchment Area -------------------------
Analysis_Line <- function(Data){
  
  Data <- Data[Data$Frequency > 0,]
  
  png(file = file.path(iPath_Image,paste0(names(Data[2]), "Frequency vs. Site Count",".png")), width = 1600, height = 800)
  par(mfrow = c(1, 2))
  
  plot(Data$Site_Count, (Data$Frequency/15), xaxt = "n", log = "y", pch = 21, cex = 1.95, bg = "blue", col = "black", xlab = "Site Count", 
       ylab = "Frequency (Median BtoP & PtoB)", main = paste(names(Data[2]), "Catchment Area vs. Frequency"), cex.axis = 1.5, cex.lab = 1.5, cex.main = 1.5)
  axis(side = 1, at = seq(0,max(Data$Site_Count),10), cex.axis = 1.5)
  lines(lowess(Data$Site_Count,(Data$Frequency/15)), col="black", lwd = 2)
  
  legend("topright", c(names(Data[1]), "Lowess Line"), pch = c(21,NA), lwd = 2, lty = c(NA,1), col = c("black","black"), pt.bg = "blue",
         ncol = 1, cex = 1.25, pt.cex = 1.95, bg = "grey96")
  
  plot(Data$Catchment_Area, (Data$Frequency/15), pch = 25, cex = 1.95, bg = "red", col = "black", xlab = "Catchment Area (Square km)", 
       ylab = "Frequency (Median BtoP & PtoB)", log="xy", main = paste(names(Data[2]), "Catchment Area vs. Frequency"),
       cex.axis = 1.5, cex.lab = 1.5, cex.main = 1.5)
  lines(lowess(Data$Catchment_Area,(Data$Frequency/15)), col="black", lwd = 2)

    legend("topright", c(names(Data[2]), "Lowess Line"), pch = c(25,NA), lwd = 2, lty = c(NA,1), col = c("black","black"), pt.bg = "red",
         ncol = 1, cex = 1.25, pt.cex = 1.95, bg = "grey96")
  
  dev.off()
}

# Histogram for Frequecy --------------------------------------------------
Analysis_Histogram <- function(Data){

  Data <- Data[Data$Frequency > 0,]
  
  png(file = file.path(iPath_Image,paste0(names(Data[2]), "Frequency Histogram",".png")), width = 1200, height = 800)
  
  breaks <- seq(0,max(Data$Frequency/15), .5)
  
  hist(log(Data$Frequency/15), main = paste(names(Data[2]), "Event Frequency Histogram"), 
      xlab = "Number of Events per Year (Median BtoP & PtoB)", col = "tan", 
      cex.axis = 1.25, cex.lab = 1.5, cex.main = 1.5, xaxt = "n")

  at = log(breaks)
  
  axis(side = 1, at = at, labels = exp(at))
  
  abline(v = median(log(Data$Frequency/15)), col = "red", lwd = 2)
  
  Med <- median((Data$Frequency/15))
  Med <- format(round(Med, 2), nsmall = 2)
  
  legend("topright",c(paste("Median:", Med)), lwd = 2, lty=1, 
         col = c("red"), ncol=1, cex = 1.35, bg="grey96", text.font = 3) 
  
  dev.off()
}

# Histogram for Site Count ------------------------------------------------
Analysis_Histogram_Site <- function(Data){
  
  png(file = file.path(iPath_Image,paste0(names(Data[1]), "Site Count Histogram",".png")), width = 1600, height = 800)
  
  hist(Data$Site_Count, main = paste(names(Data[1]), "Site Count Histogram"), xlab = "Number of Sites", col = "thistle", 
       xaxt = 'n', cex.axis = 1.25, cex.lab = 1.5, cex.main = 1.5)
  
  abline(v = mean(Data$Site_Count), col ="springgreen4", lwd = 2)
  abline(v = median(Data$Site_Count), col = "red", lwd = 2)
  axis(side = 1, at = seq(0, max(Data$Site_Count), 5))
  
  Mu <- mean(Data$Site_Count)
  Mu <- format(round(Mu, 2), nsmall = 2)
  Med <- median(Data$Site_Count)
  Med <- format(round(Med, 2), nsmall = 2)
  
  legend("topright",c(paste("Mean:", Mu),paste("Median:", Med)), lwd = 2, lty=c(1, 1), 
         col = c("springgreen4","red"), ncol=1, cex = 1.35, bg="grey96", text.font = 3) 
  
  dev.off()
}

# Histogram for Interevent Spacing ----------------------------------------
Analysis_Histogram_Spacing <- function(Data){
  
  png(file = file.path(iPath_Image,paste0(names(Data[1]), "Interevent Spacing Histogram",".png")), width = 1600, height = 800)
  
  breaks <- c(0,1,2,5,10,20,30,40,50,100,1000,2000,4000)
  major <- c(0,1,10,100,1000,4000)

  H <- hist(log(Data$Inter_Min),plot = F)

  plot(H$mids, H$counts, type = "n", xaxt = "n", main = paste(names(Data[1]), "Interevent Spacing Histogram"),
       xlab = "Minimum Spacing", ylab = "Count")

  abline(v=log(breaks),col="lightgrey",lty=2)
  abline(v=log(major),col="lightgrey")
  abline(h=pretty(H$counts),col="lightgrey")

  plot(H, add = T, freq = T, col = "coral")

  at <- log(breaks)
  axis(side = 1, at = at, labels = exp(at))
  
  dev.off()
}

# Line Plots Selected Sites (Different Windows) -------------------------
Analysis_TemporalPlot <- function(Temporal_Window){
  Temporal_Windows <- read.csv(file.path(iPath_Out_Meta, Temporal_Window), header = TRUE, sep = ",")
  for (i in 1:nrow(Temporal_Windows)) {
    ofile <- Temporal_Windows$HUC8
    png(file = file.path(iPath_Image,paste0("0",ofile[i],"_Temporal_Est",".png")), width = 1600, height = 800)
    
    par(mar = c(6,6,5,5))
    plot(seq(2,30,1), Temporal_Windows[i,5:ncol(Temporal_Windows)], type = "l", lty = 5, lwd = 3, col = "red", 
         main = paste0("0",ofile[i], " Temporal Windows vs. Frequency"),xlab = "Temporal Windows (# of Days)" , ylab = "Frequency",
         cex.axis = 1.25, cex.lab = 1.5, cex.main = 1.75)
    #points(Temporal_Windows[i,4], pch = 16, col = "black", cex = 2)
    
    Median = Temporal_Windows[i,4]
    legend("topright", c(paste("Median (BtoP, PtoB):", Median)), cex = 1.75, bg = "grey96", text.font = 3)
    
    print(paste("Figure Created:", ofile[i])) 
    
    dev.off()
  }
  
}

# NCDC Frequency Plots ----------------------------------------------------
Analysis_Line_NCDC <- function(File){
  NCDC <- read.csv(file.path(iPath_Out_Meta, File), header=TRUE, sep = ",")
  
    png(file = file.path(iPath_Image,paste0("NCDC_Est",".png")), width = 1600, height = 800)
    Max <- NULL
    for(i in 1:nrow(NCDC)){
      Max[i] <- max(NCDC[i,4:ncol(NCDC)])
    }
    
    par(mar = c(6,6,5,5))
    plot(seq(1,10,1), NCDC[1,4:ncol(NCDC)], type = "l", lty = 1, lwd = 2, col = 1,  
         main = paste0(" Temporal Windows vs. NCDC Frequencies"),xlab = "Lag within Overlap (# of Days)" , ylab = "Frequency",
         cex.axis = 1.35, cex.lab = 1.5, cex.main = 1.75, ylim = c(0,max(Max)), xaxt = "n")
    xlabels = names(NCDC[4:ncol(NCDC)])
    axis(side = 1, at = seq(1,10,1), labels = xlabels, cex.axis = 1.35, cex.lab = 1.5)
    for (j in 2:nrow(NCDC)) {  
        lines(seq(1,10,1), NCDC[j,4:ncol(NCDC)], type = "l", lty = 1, lwd = 2, col = j)
    }
  dev.off()
}

# HUC8 Time Frame Frequency Comparison ------------------------------------
Analysis_Compare <- function(File){
  Comparison <- read.csv(file.path(iPath_Out_Meta, File), header = TRUE, sep = ",")
  
  png(file = file.path(iPath_Image,paste0("HUC8 Frequency Comparison",".png")), width = 1600, height = 800)
  
  par(bg = "grey96")
  plot(seq(1,23,1), Comparison[,8], pch=15, col = "blue1", cex = 2.2, xaxt = "n", xlab = "HUC8",ylab = "Annual Frequency (Events per Year)", 
       main ="Annual Frequency Comparisons between Varying Year Groupings")
  points(seq(1,23,1), Comparison[,9], pch = 16, col = "brown1", cex = 2.2)
  points(seq(1,23,1), Comparison[,10], pch = 17, col = "darkgreen", cex = 2.2)
  points(seq(1,23,1), Comparison[,11], pch = 18, col = "darkorchid3", cex =2.2)
  xlabels <- as.character(paste0("0",Comparison$HUC8))
  axis(side = 1, at = seq(1,23,1), labels = xlabels, cex.axis = .8, cex.lab = 1.2)
  legend("topright", c("2010-2015","2000-2015","1985-2015","1965-2015"), title = "Year Groups", pch = c(15,16,17,18), 
         col = c("blue1","brown1","darkgreen","darkorchid3"), cex = 1.75, pt.cex = 2.2 )
  
  dev.off()
  
}

# #Duration Plot ----------------------------------------------------------
Analysis_Duration <- function(Data){
  Data <- Data[Data$Frequency >0,]
  Data <- Data[Data$Site_Count >=3,]
  
  png(file = file.path(iPath_Image,paste0(names(Data[2]), "Duration Comparison",".png")), width = 1200, height = 800)

  Data <- Data[order(Data$Duration_Max, Data$Duration_Mean, Data$Duration_Min), ]

  plot(ecdf(Data$Duration_Max), col = "blue4", xlab = "Duration(Days)", ylab = "Percentage of HUC's", xlim = c(2, max(Data$Duration_Max)), log = "x",
       main = paste(names(Data[2]), "Event Duration Distributions"), lty = 'solid', lwd = 2, do.points = F, verticals = T)
  plot(ecdf(Data$Duration_Mean), col = "forestgreen", add = T, lty = 'solid',lwd = 2, do.points = F, verticals = T)
  plot(ecdf(Data$Duration_Min),  col = "firebrick3", add = T, lty ='solid', lwd = 2, do.points = F, verticals = T)

  legend("bottomright", c("Max Duration", "Mean Duration", "Minimum Duration"), title = "Duration Groups",
         fill = c("blue4", "forestgreen", "firebrick3"), cex = 1.35)
  
  dev.off()
}

# Severity Plot -----------------------------------------------------------
Analysis_Severity <- function(Data){
  png(file = file.path(iPath_Image, paste(names(Data[6]), "Severity Distribution.png")), width = 1600, height = 800)
  
  breaks <- c(0,.1,.2,.3,.4,.5,1,1.5,2,2.5,5,10,15,20,25)
  major <- c(0,1,5,10,20)
  
  H <- hist(log(Data$Severity),plot = F)
  
  plot(H$mids, H$counts, type = "n", xaxt = "n", main = paste(names(Data[6]), "Severity Distribution for All Events: HUC8"),
       xlab = "Severity", ylab = "Frequency", cex.lab = 1.25, cex.main = 1.25)
  
  abline(v=log(breaks),col="lightgrey",lty=2)
  abline(v=log(major),col="lightgrey")
  abline(h=pretty(H$counts),col="lightgrey")

  plot(H, add = T, freq = T, col = "red")
  abline(v = log(median(Data$Severity)), col = "black", lwd = 3 )
    
  at <- log(breaks)
  axis(side = 1, at = at, labels = exp(at))
  
  Med <- median(Data$Severity)
  Med <- format(round(Med, 2), nsmall = 2)
  
  legend("topright", c(paste("Median Severity", Med)), lty = 1, lwd = 3, col = "black", cex = 1.25)
  
  dev.off()
}

# Duration Comparison -----------------------------------------------------

Duration_Comparison <- function(File){
  Historical <- read.csv(file.path(iPath_Out_Meta, File), header = TRUE, sep = ",")
  
  png(file = file.path(iPath_Image, "Historical Event Comparison NCDC.png"), width = 800, height = 800)
  
  #par(mfrow = c(2, 1))
  
  # plot(Historical$Wiki, Historical$POT_Method, col = "blue", pch = 15, cex = 1.95, xlab = "Wiki", ylab = "POT Method",
  #      cex.axis = 1.35, cex.lab = 1.35, main = "Wiki vs. POT Duration Comparison", cex.main = 1.5)
  # abline(0,1, lty =1, lwd = 3)
  
  plot(Historical$NCDC, Historical$POT_Method, col ="red", pch = 16, cex = 1.95, xlab = "NCDC" , ylab = "POT Method",
       cex.axis = 1.35, cex.lab = 1.35, main = "NCDC vs. POT Duration Comparison", cex.main = 1.5)
  abline(0,1, lty = 1, lwd = 3)
  
  dev.off()
}
